%------------------------------------------------------------------------------
% File     : SEV144^5 : TPTP v7.4.0. Bugfixed v5.2.0.
% Domain   : Set Theory (Relations)
% Problem  : TPS problem from TRANSITIVE-CLOSURE
% Version  : Especial.
% English  :

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0933 [Bro09]

% Status   : Theorem
% Rating   : 1.00 v7.3.0, 0.89 v7.2.0, 0.88 v7.1.0, 1.00 v5.2.0
% Syntax   : Number of formulae    :    3 (   0 unit;   1 type;   1 defn)
%            Number of atoms       :   35 (   1 equality;  31 variable)
%            Maximal formula depth :   13 (  10 average)
%            Number of connectives :   31 (   0   ~;   0   |;   3   &;  22   @)
%                                         (   1 <=>;   5  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   16 (  16   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    3 (   1   :;   0   =)
%            Number of variables   :   14 (   0 sgn;  12   !;   0   ?;   2   ^)
%                                         (  14   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
% Bugfixes : v5.2.0 - Added missing type declarations.
%------------------------------------------------------------------------------
thf(cTCLOSED_type,type,(
    cTCLOSED: ( $i > $i > $o ) > ( $i > $i > $o ) > $o )).

thf(cTCLOSED_def,definition,
    ( cTCLOSED
    = ( ^ [Xp: $i > $i > $o,Xs: $i > $i > $o] :
        ! [Xu: $i,Xv: $i,Xw: $i] :
          ( ( ( Xp @ Xu @ Xv )
            & ( Xs @ Xv @ Xw ) )
         => ( Xp @ Xu @ Xw ) ) ) )).

thf(cTHM146B_pme,conjecture,(
    ! [Xr: $i > $i > $o,Xx: $i,Xy: $i] :
      ( ! [Xp: $i > $i > $o] :
          ( ( ! [Xx0: $i,Xy0: $i] :
                ( ( Xr @ Xx0 @ Xy0 )
               => ( Xp @ Xx0 @ Xy0 ) )
            & ( cTCLOSED @ Xp @ Xr ) )
         => ( Xp @ Xx @ Xy ) )
    <=> ! [Xp: $i > $i > $o] :
          ( ( ! [Xx0: $i,Xy0: $i] :
                ( ( Xr @ Xx0 @ Xy0 )
               => ( Xp @ Xx0 @ Xy0 ) )
            & ( cTCLOSED @ Xp @ Xp ) )
         => ( Xp @ Xx @ Xy ) ) ) )).

%------------------------------------------------------------------------------
